function Test() {
   alert("AcMap.js");
}

function Highlight(Elem, Color) {
   // Applies hand pointer, underline, and color (optional) to Elem.
   // Elem   Element to be highlighted
   // Color  0 = No color change
   //        Any other integer or omitted = Color change
   // Works with UnHighlight function.
   Elem.style.cursor = "hand";
   if (Color != 0) {
      Elem.style.color = "#33c";
   }
   Elem.style.textDecoration = "underline";
}

function UnHighlight(Elem, Color) {
   // Removes hand pointer, underline, and color (optional) from Elem, but
   // only if they were set programatically, and restores these settings to
   // underlying values set by stylesheet or Style attribute.
   // Elem   Element to be un-highlighted
   // Color  0 = No color change
   //        Any other integer or omitted = Color change
   // Works with UnHighlight function.
   Elem.style.cursor = "";
   if (Color != 0) {
      Elem.style.color = "";
   }
   Elem.style.textDecoration = "none";
}

function MakeVisible(Context, Head, Body) {
   // On event in Head, makes Body visible, makes all other Bodies
   // invisible, undoes color change and underline in all other Heads.
   // Action restricted to scope of Context.
   // Context  ID of Div to which the action of this function is restricted
   // Head     ID of the trigger element, or "this"
   // Body     ID of the element to be made visible
   //
   // For each element in Context
   for (i = 0; i < Context.all.length; i++) {
      with (Context.all[i].style) {
         ThisId = Context.all[i].id + ""
         // If it's a head
         if (ThisId.charAt(0) == "A") {
            textDecoration = "none";
            color="#306";
         }
         // If it's a body
         if (ThisId.charAt(0) == "B") {
            visibility = "hidden";
         }
      }
   }
   with (Head.style) {
      textDecoration = "underline";
      color = "#39f";
   }
   Body.style.visibility = "visible";
}

function Display(Context, Head, Body, Image) {
   // On click in Head, makes Body display, makes all other Bodies
   // not display, undoes color change and underline in all other Heads.
   // Action restricted to scope of Context.
   // Context  ID of Div to which the action of this function is restricted
   // Head     ID of the trigger element, or "this"
   // Body     ID of the element to display
   // Image    ID of the "open/closed" image element associated with Head
   // You can call this function without the last parameter if there is
   // no "open/closed" image element.
   if (Body.style.display == "block") {
      Body.style.display = "none";
      Image.src = "Closed.gif";
   }
   else {
      // For each element in Context
      for (i = 0; i < Context.all.length; i++) {
         with (Context.all[i]) {
            ThisId = Context.all[i].id + ""
            // If it's a head
            if (ThisId.charAt(0) == "M") {
               // Do nothing
            }
            // If it's a body
            if (ThisId.charAt(0) == "N") {
               style.display = "none";
            }
            // If it's an open-closed image
            if (ThisId.charAt(0) == "i") {
               src = "Closed.gif";
            }
         }
      }
      Body.style.display = "block";
      Image.src = "Open.gif";
   }
}

function DisplayComment(Context, Head, Body, Image) {
   // On mouse-over in Head, makes Body display, makes all other Bodies
   // not display, undoes color change and underline in all other Heads.
   // Action restricted to scope of Context.
   // Context  ID of Div to which the action of this function is restricted
   // Head     ID of the trigger element, or "this"
   // Body     ID of the element to display
   // Image    ID of the "open/closed" image element associated with Head
   // You can call this function without the last parameter if there is
   // no "open/closed" image element.
   //
   // Reset each element in Context
   for (i = 0; i < Context.all.length; i++) {
      with (Context.all[i]) {
         ThisId = Context.all[i].id + ""
         // If it's a head
         if (ThisId.charAt(0) == "A") {
            // Do nothing
         }
         // If it's a body
         if (ThisId.charAt(0) == "B") {
            style.display = "none";
         }
         // If it's an open-closed image
         if (ThisId.charAt(0) == "i") {
            src = "Closed.gif";
         }
      }
   }
   Body.style.display = "block";
   Image.src = "Open.gif";
}

var newWin;  // New window defined by the OpenWindow function
function OpenWindow(Url)
// Opens a file in a new window with parameters hard-coded within the function.
// Url     URL of the file to open in the new window
{
    newWin = window.open(url,"CodeWin","scrollbars,resizable,width=550,height=400");
    newWin.focus();
}

function ShowHide(Elem) {
// Simple show-hide as with inline popups
// Elem   ID of element to show or hide
   if (Elem.style.display == "block") {
      Elem.style.display = "none";
   }
   else {
   Elem.style.display = "block";
   }
}

// Builds a ShortCut object to launch a CHM (with local path)
// build_hhrun_object -
//
function build_hhrun_object(file) {
  var path = location.pathname;
  var i = path.lastIndexOf("\\");
  var j = path.indexOf(":", 3);
  path = path.substring(j+1,i+1);
  document.writeln("<OBJECT id=hhrun type='application/x-oleobject'");
  document.writeln("  classid='clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11'");
  document.writeln("  codebase='hhctrl.ocx#Version=4,73,8561,0'>");
  document.writeln(" <PARAM name='Command' value='ShortCut'>");
  document.writeln(" <PARAM name='Item1' value=',hh.exe," + path + file + "'>");
  document.writeln(" <PARAM name='Window'  value='bogus.html'>");
  document.writeln("</OBJECT>");
}

function set_browse_buttons(show) {

// if the current record contains a show code
// (three digits, each 0  or 1, specifying if
// the corresponding browse button is on or off)
if (show != "")
   {
      // make browse button group visible
      document.all.head_nav.style.visibility = "visible";
      // show or hide buttons according to their show codes
      if (show.charAt(0) != 1)
         document.all.nav_prev.outerHTML = "";
         // document.all.nav_prev.outerHTML = "<img src='graphics/nav-prev-xp-o.gif' border='0'>";
         // document.all.nav_prev.style.visibility = "hidden";
      if (show.charAt(1) != 1)
         document.all.nav_up.outerHTML = "";
         // document.all.nav_up.outerHTML = "<img src='graphics/nav-up-xp-o-2.gif' border='0'>";
         // document.all.nav_up.style.visibility = "hidden";
      if (show.charAt(2) != 1)
         document.all.nav_next.outerHTML = "";
         // document.all.nav_next.outerHTML = "<img src='graphics/nav-next-xp-o.gif' border='0'>";
         // document.all.nav_next.style.visibility = "hidden";
   }
}


// data-binding function for ref topics
function ChangeRecord(LinkTextObj, ListObj) {
   var FilterExpr = "";
   FilterExpr = "Command=" + LinkTextObj.id;
   commands.object.Filter = FilterExpr;
   commands.Reset();
   for (var i = 0; i < ListObj.all.length; i++) {
      ListObj.all[i].style.color = "#57b";
   }
   LinkTextObj.style.color = "#137";
   LinkTextObj.style.textDecoration = "none";
}



//-------------------------------------------
// Added by IntelliArts
//-------------------------------------------
function swapImage(theImgObj, theImage1, theImage2) {
	if (theImgObj.src.search(trimRelativePath(theImage1)) > 0 || theImage1 == theImgObj.src) {
		theImgObj.src = theImage2
	} else {
		theImgObj.src = theImage1
	}
}

function trimRelativePath(path) {
	if (path.indexOf('./') == 0) {
		return trimRelativePath(path.substring(2));
	} else if (path.indexOf('../') == 0) {
		return trimRelativePath(path.substring(3));
	} else if (path.indexOf('../') > 0) {
		if (path.indexOf('/') < path.indexOf('../')) {
			return trimRelativePath(path.substring(0,path.indexOf('/'))+path.substring(path.indexOf('../')+3));
		} else return path;
	} else {
		return path;
	}
}

function showHide(theId) {
	if (document.getElementById) { // DOM3 = IE5, NS6
		el = document.getElementById(theId)
		if (el.style.display == 'none') {
			showElement(el)
		}
		else {
			hideElement(el)
		}
	}
}

function hideElement(theEl) {
	theEl.style.display = 'none';
}
function showElement(theEl) {
	theEl.style.display = '';
}

function linkParser(fn) {
	var X, Y, sl, a, ra, link;
	ra = /:/;
	a = location.href.search(ra);
	if (a == 2)
	X = 14;
	else
	X = 7;
	sl = "\\";
	Y = location.href.lastIndexOf(sl) + 1;
	var tmpRes = location.href.substring(X, Y) + fn;
	if (!(location.href.search('file:///') >= 0))
		tmpRes = 'file:///' + tmpRes;
	return tmpRes;
}

function linkHelpFile(fn, tn) {
	var fileUrl = linkParser(fn);
	var tmpRes = 'mk:@MSITStore:' + fileUrl;
	if (tn != null)
		tmpRes += '::/' + tn;
	return tmpRes;
}

//-------------------------------------------
//ExpandAll CollapseAll scripts
try {
// trying to add Mozzila event listener
	window.addEventListener("load",CheckForCollapsible, true);
} catch (e) {
// wrong adding IE event
	window.attachEvent("onload",CheckForCollapsible);

}


//addLoadEvent(CheckForCollapsible);

/* essential global variables */
var divPattern;
var els;
var elsLen;
var collapseExists = false;
var collapseSection;
var expandSection;
var collapsedImagePath;
var expandedImagePath;

function CheckForCollapsible() {

	divPattern = new RegExp(/collapsible\w+/);
	els = document.getElementsByTagName('div');
	elsLen = els.length;
	collapseSection = document.getElementById("collapseAllSection");
	expandSection = document.getElementById("expandAllSection");

	var i = 0;
	while (i < elsLen && !collapseExists) {
		if (divPattern.test(els[i].getAttribute("id")))
			collapseExists = true;
		i++;
	}

	if (collapseExists) {
		expandSection.style.display = "block";
		try {
			collapsedImagePath = document.getElementById("collapse_img").src;
			expandedImagePath = document.getElementById("expand_img").src;
		} catch( e) {

		}
	}

}   // function CheckForCollapsible()

function swapLabel()
{
    if (collapseSection.style.display == "block")
    {
		collapseSection.style.display = "none";
		expandSection.style.display = "block";
    } else {
		collapseSection.style.display = "block";
		expandSection.style.display = "none";
    }
}

function ExpandOrCollapse()
{

    var imgPattern = new RegExp(/d\w+/);
    var imgID = document.getElementsByTagName('img');
    var imgIDLen = imgID.length;

    for (i = 0; i < elsLen; i++) {
        if ( divPattern.test(els[i].getAttribute("id")) ) {
            ShowHide(els[i]);
        }
    }

	for (j = 0; j < imgIDLen; j++) {
		if ( imgPattern.test(imgID[j].getAttribute("id")) ) {
			swapImage(imgID[j], expandedImagePath, collapsedImagePath);
		}
	}

    swapLabel();
}

// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFI/LYXijjWad
// SIG // XC7HY7aapUSZkSRcoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFEApEZthVGJJVmmCdki8UexerqU5MFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYBi
// SIG // Z75Ljm+prZSAqnOmAHwnxQo1IN3UckzJ+c9b2qfwKR8m
// SIG // Wjf1iydoLFXMBNbrAt326RScOX+fRCBoUZMwM1wof8Qb
// SIG // WYCjKlNhhP3Z58Ph0V46/+qJvhv6Ip2MYScJY16rLYFy
// SIG // HxsOWTsDdMvpa2d764yUTWyxrNC0g6xT+irSYqGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMzMDQ3
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUkpEvBRm4VV4xKiW012Z/
// SIG // lNJrNIswDQYJKoZIhvcNAQEBBQAEgYBClY8dR1nFYUA5
// SIG // Kn2ZQD7H4O2OogQYarpDE5jO/vtqMonP8nOsLgmu19k6
// SIG // OVfitg1ZazT6tBc+D3IB5OTgKzjwKDTEOMkK6AaSf38a
// SIG // Bx77GuOnMfIlvxP8ZidHqCzX11VwvuSCpdvQ0mdxv40q
// SIG // iw4Q5UYKOClMGXz+jMv7J2N14w==
// SIG // End signature block
